#ifndef __Windowing__
#define __Windowing__

/**
 * @file Windowing.h
 * @brief Single include for the Windowing package
 *
 * @date 18/03/2005
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Windowing.h,v 1.3 2007/02/08 21:07:54 paul Exp $
 */

/**
 * @namespace Exponent::GUI::Windowing
 * @brief Window handling classes
 *
 * Provides routines that deal with heavy weight window objects
 */

#include "CAboutWindow.hpp"
#include "CClip.hpp"
#include "CCursor.hpp"
#include "CMenuWindow.hpp"
#include "CMouse.hpp"
#include "CWindow.hpp"
#include "CWindowAttributes.hpp"
#include "CWindowTools.hpp"
#include "IToolTip.hpp"
#include "IToolTipSupportingWindow.hpp"
#include "IWindow.hpp"
#include "SWindowHandle.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::GUI::Windowing;
#endif

#endif	// End of Windowing.h